<?php
/* --------------------------------------------------------------
 BootstrapperInterface.php 2020-03-10
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Application\Kernel;

use Gambio\Core\Application\Application;

/**
 * Interface BootstrapperInterface
 * @package Gambio\Core\Application\Kernel\Bootstrapper
 */
interface Bootstrapper
{
    /**
     * BootstrapperInterface constructor.
     *
     * Bootstrapper should not contain any constructor logic.
     * They should handle everything in the boot method.
     */
    public function __construct();
    
    
    /**
     * Bootstrap of additional functionality.
     *
     * @param Application $application
     */
    public function boot(Application $application): void;
}